/* $XFree86: xc/programs/Xserver/hw/xfree86/vga256/drivers/mxic/mxic_misc.c,v 1.1.2.3 1997/05/28 13:12:53 dawes Exp $ */

/*
 *
 * Copyright 1995-1997 The XFree86 Project, Inc.
 *
 */

/* 
 * Various functions used in the virge driver. 
 * Right now, this only contains the PCI probing function.
 * 
 * Created 18/03/97 by Sebastien Marineau
 * Revision: 
 * [0.1] 18/03/97: Added PCI probe function, taken from accel/s3_virge server.
 *       Not sure if the code used to adjust the PCI base address is 
 *       still needed for the ViRGE chipsets.
 */
/*
 * Ported to MX8625x by Stephen H.L.Wang
 *
 * version 0.2.1 - 11/8/1998
 *	1. No change.
 *
 * version 0.2alpha - 12/29/1997
 */

#include "X.h"
#include "input.h"
#include "screenint.h"

#include "compiler.h"
#include "xf86.h"
#include "xf86Priv.h"
#include "xf86_OSlib.h"
#include "xf86_HWlib.h"
#include "xf86_PCI.h"
#include "vga.h"
#include "vgaPCI.h"

#ifdef XFreeXDGA
#include "X.h"
#include "Xproto.h"
#include "scrnintstr.h"
#include "servermd.h"
#define _XF86DGA_SERVER_
#include "extensions/xf86dgastr.h"
#endif

#define XCONFIG_FLAGS_ONLY
#include "xf86_Config.h"

#include "mxic_driver.h"


/*
 * mxicGetPCIInfo -- probe for PCI information
 */

MXICPCIInformation *
mxicGetPCIInfo()
{
   static MXICPCIInformation info = {0, };
   pciConfigPtr pcrp, *pcrpp;
   Bool found = FALSE;
   int i = 0;

   pcrpp = xf86scanpci(vga256InfoRec.scrnIndex);

   if (!pcrpp)
   {
#ifdef DEBUGTRACE
      ErrorF(" mxicGetPCIInfo: xf86scanpci(%i) return NULL!\n", vga256InfoRec.scrnIndex);
#endif
      return NULL;
   }

   while ((pcrp = pcrpp[i])) {
#ifdef DEBUGTRACE
      ErrorF(" mxicGetPCIInfo: pcrpp[%i].vendor=%04X.device=%04X!\n", i, pcrp->_vendor, pcrp->_device);
#endif
      if (pcrp->_vendor == PCI_MXIC_VENDOR_ID) {
	 found = TRUE;
	 switch (pcrp->_device) {
	 case PCI_MX86250:
	    info.ChipType = MXIC_MX86250;
	    break;
	 case PCI_MX86251:
	    info.ChipType = MXIC_MX86251;
	    break;
	 default:
	    info.ChipType = MXIC_UNKNOWN;
	    info.DevID = pcrp->_device;
	    break;
	 }
	 info.ChipRev = pcrp->_rev_id;
	 info.MemBase = pcrp->_base0 & 0xFF800000;
	 break;
      }
      i++;
   }

   /* Free PCI information */
   xf86cleanpci();
#ifdef DEBUGTRACE
   ErrorF("%s %s: MXIC: %s rev %x, Linear FB @ 0x%08lx\n", XCONFIG_PROBED,
	   vga256InfoRec.name,xf86TokenToString(mxicChipTable, info.ChipType), 
	   info.ChipRev, info.MemBase);
#else
   if (found && xf86Verbose) {
      if (info.ChipType != MXIC_UNKNOWN) {
	 ErrorF("%s %s: MXIC: %s rev %x, Linear FB @ 0x%08lx\n", XCONFIG_PROBED,
		vga256InfoRec.name,xf86TokenToString(mxicChipTable, info.ChipType), 
		info.ChipRev, info.MemBase);
      }
   }
#endif

   if (found)
      return &info;
   else
      return NULL;
}



